--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Quest Variables
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local xDialog = gDialogTable.x or 100
local yDialog = gDialogTable.y or 50

-------------------------------------------------------------------------------

local layout = {}
local x = 0
local y = 0
local dy = bsgFontHeight(devPopupFont)

for var,val in pairs(LQuest._Variables) do
	table.insert(layout, TextEdit { x=x,y=y, w=30,h=dy, label=tostring(val), name=var })
	table.insert(layout, Text { x=x+30,y=y, w=200,h=dy, label="#"..var })
	y = y + dy
end

-------------------------------------------------------------------------------

local function Done()
	for var,_ in pairs(LQuest._Variables) do
		val = GetLabel(var) or "0"
		val = tonumber(val) or 0
		LQuest._Variables[var] = val
	end
	CloseWindow()
end

-------------------------------------------------------------------------------

MakeDialog
{
	AppendStyle { font=devPopupFont },
	Rectangle
	{
		x=xDialog,y=yDialog,w=210,h=200,
		inset=3, fit=true,
		Group(layout),
		
		SetStyle(standardStyle),
		TextButton { x=0,y=y, name="ok", label="ok", command=Done },
	}
}
